ALTER PROCEDURE usp_Insert_Supervision_Rating_Scale
AS
BEGIN

BEGIN
INSERT INTO [V5_Registry].[dbo].[STD_SURVEY_TYPE]
           ([CODE],[NAME],[DESCRIPTION_TEXT],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES
           ('SRS', 'Supervision Rating Scale', 'Supervision Rating Scale', 'Initial', 'Initial', GETDATE(), GETDATE())
END

BEGIN
declare @type     int;


SELECT @type=  (SELECT ID [STD_SURVEY_TYPE_ID]
FROM STD_SURVEY_TYPE
WHERE CODE = 'SRS')

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '1', 'Circle the rating that is closest to the amount of supervision that the patient actually receives. "Supervision means 
that someone is responsible for being with the patient.', 1, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

END

BEGIN

declare @question     int, 
        @maxchoice    int,
        @choice       int;
   
SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'SRS' and t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 1)
----1
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1'
           ,'The patient lives alone or independently. Other persons can live with the patient, but they cannot take responsibility for supervision 
(for example, a child or elderly person).', @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----2
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2'
           ,'The patient is unsupervised overnight. The patient lives with one or more persons who could be
responsible for supervision (for example, a spouse or roommate); but they are all sometimes absent overnight.', @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----3
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3'
           ,'The patient is only supervised overnight. One or more supervising persons are always present
overnight but they are all sometimes absent for the rest of the day.', @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---4
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4'
           ,'The patient is supervised overnight and part-time during waking hours, but is allowed on
independent outings. One or more supervising persons are always present overnight and are also
present during part of waking hours every day. However, the patient is sometimes allowed to
leave the residence without being accompanied by someone who is responsible for supervision.'
, @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---5
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5'
           ,'The patient is supervised overnight and part-time during waking hours, but is unsupervised during
working hours. Supervising persons are all sometimes absent for enough time for them to work
full-time outside the home.'
, @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---6
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6'
           ,'The patient is supervised overnight and during most waking hours. Supervising persons are all
sometimes absent for periods longer than one hour, but less than the time needed to hold a fulltime
job away from home.'
, @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---7
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7'
           ,'The patient is supervised overnight and during almost all waking hours. Supervising persons are
all sometimes absent for periods shorter than one hour.'
, @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---8
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '8'
           ,'The patient is under full-time indirect supervision. At least one supervising person is always
present, but the supervising person does not check on the patient more than once every 30 minutes.'
, @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---9
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '9'
           ,'Same as #8 plus requires overnight safety precautions (for example, a deadbolt on outside door).'
, @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---10
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '10'
           ,'The patient is under full-time direct supervision. At least one supervising person is always present
and the supervising person checks on the patient more than once every thirty minutes.'
, @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---11
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '11'
           ,'The patient lives in a setting in which the exits are physically controlled by others (for example, a
locked ward).'
, @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---12
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '12'
           ,'Same as #11 plus a supervising person is designated to provide full-time line-of-sight supervision
(for example; an escape watch or suicide watch).'
, @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---13
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
IF @maxchoice is null
    BEGIN SET @choice = 1 END
ELSE
    BEGIN SET @choice = @maxchoice + 1 END

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '13'
           ,'The patient is in physical restraints.'
, @choice, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

/*
SELECT * FROM [V5_Registry].[dbo].[STD_SURVEY_TYPE]
SELECT * FROM [V5_Registry].[dbo].[STD_QUESTION]
SELECT * FROM [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
*/

END

END